#include "caller.h"

int caller_items;
char **list_caller;
struct reg_node **list_reg;

int isUnRegCaller(const char *name)
{
	int i;
	
	//printf("%s at isUnRegCaller\n", name);
	//LOGI("%s at isUnRegCaller\n", name);
	
	if(caller_items == 0)
		return 1;
	
	for(i = 0;i<caller_items;i++)
	{
		if(list_reg[i] != NULL)
		{
			if(strcmp(name, list_reg[i]->name) == 0)
			{
				struct reg_node *temp = list_reg[i]->next;
				free(list_reg[i]);
				list_reg[i] = temp;
				return 1;
			}
		}
	}

	return -1;
}

int isRegCaller(const char *caller, const char *name)
//int isRegCaller(char *caller, char *name)
{
	int i;
	
	//printf("[%s] [%s] at isRegCaller\n", caller, name);
	//LOGI("[%s] [%s] at isRegCaller\n", caller, name);
	
	if(caller_items == 0)
		return 1;
	
	//is start point?
	/*for(i = 0;i<caller_items;i++)
	{
		if(strcmp(name, list_caller[i]) == 0)
			return 1;
	}*/
	
	for(i = 0;i<caller_items;i++)
	{
		if(list_reg[i] != NULL)
		{
			if(strcmp(caller, list_reg[i]->name) == 0)
			{
				struct reg_node *newreg = (struct reg_node *)malloc(sizeof(struct reg_node));
				newreg->name = (char *)malloc(sizeof(char) * strlen(name) + 1);
				newreg->next = NULL;
				strcpy(newreg->name, name);
				newreg->next = list_reg[i];
				list_reg[i] = newreg;
				//LOGI("RegB");
				return 1;
			}
		}
		else
		{
			if(strcmp(caller, list_caller[i]) == 0)
			{
				struct reg_node *newreg = (struct reg_node *)malloc(sizeof(struct reg_node));
				newreg->name = (char *)malloc(sizeof(char) * strlen(name) + 1);
				newreg->next = NULL;
				strcpy(newreg->name, name);
				list_reg[i] = newreg;
				//LOGI("RegN");
				return 1;
			}
		}
	}
	
	return -1;
}

int loadCaller()
{
	FILE *caller_file = NULL;
	int i;
	char buf[MAX_BUF];
	char *data;
	
	//printf("loadCaller\n");
	//LOGI("loadCaller\n");
	caller_file = fopen(CALLERCONFIG, "r");
	if (caller_file == NULL)
	{
		LOGI("Error: Can't open [%s]", CALLERCONFIG);
		//printf("Error: Can't open [%s]\n", CALLERCONFIG);
		return -1;
	}
	
	//read the number of caller_items
	memset(buf, 0, sizeof(buf));
	if (fgets(buf, MAX_BUF, caller_file) != NULL)
	{
		caller_items = atoi(buf);
		if (caller_items < 0)
		{
			LOGI("Error: Get error value in number of caller_items (%d)", caller_items);
			//printf("Error: Get error value in number of caller_items (%d)\n", caller_items);
			return -1;
		}
	}
	else
	{
		LOGI("Error: Can't read number of caller_items");
		//printf("Error: Can't read number of caller_items\n");
		return -1;
	}
	list_caller = (char **)malloc(sizeof(char *) * caller_items);
	list_reg = (struct reg_node **)malloc(sizeof(struct reg_node *) * caller_items);
	
	//store name of probes	
	for(i=0;i<caller_items;i++)
	{
		memset(buf, 0, sizeof(buf));
		if(fgets(buf, MAX_BUF, caller_file) != NULL)
		{
			int str_len;
			str_len = atoi(buf);
			if(fgets(buf, MAX_BUF, caller_file) != NULL)
			{
				data = (char *)malloc(sizeof(char) * str_len + 1);
				strncpy(data, buf, str_len);
				//data[str_len] = '\n';
				data[str_len] = '\0';
				//data[str_len + 1] = '\0';
				list_caller[i] = data;
				
				list_reg[i] = NULL;
			}
			else
			{
				LOGI("Error: Can't read name of caller");
				//printf("Error: Can't read name of caller\n");
				return -1;
			}
		}
		else
		{
			LOGI("Error: Can't read len of name");
			//printf("Error: Can't read len of name\n");
			return -1;
		}
	}

	//check
	/*for(i=0;i<caller_items;i++)
		LOGI("Index(%d):%d[%s]", i, strlen(list_caller[i]), list_caller[i]);*/
		//printf("Index(%d):%d[%s]\n", i, strlen(list_caller[i]), list_caller[i]);
	
	if (caller_file != NULL) fclose(caller_file);
		
	//LOGI("Finish load name of caller");
	//printf("Finish load name of caller\n");
	return 0;
}

void unloadCaller()
{
	int i;
	struct reg_node *temp;

	//printf("unloadCaller\n");
	//LOGI("unloadCaller\n");
	for(i=0;i<caller_items;i++)
	{
		free(list_caller[i]);
		while(list_reg[i] != NULL)
		{
			temp = list_reg[i]->next;
			free(list_reg[i]->name);
			free(list_reg[i]);
			list_reg[i] = temp;
		}
	}
	free(list_caller);
	free(list_reg);
	//printf("EunloadCaller\n");
	//LOGI("EunloadCaller\n");
}